package ru.yandex.http.util.server;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.PositiveValidator;

public interface FilesStaterConfig {
    ParameterConfig<Path> ROOT =
        new ParameterConfig<>(
            "root",
            Paths::get,
            GenericFunction.identity());

    ParameterConfig<Pattern> REGEX_FILTER =
        new ParameterConfig<>(
            "regex-filter",
            Pattern::compile,
            GenericFunction.identity(),
            true);

    ParameterConfig<Integer> MAX_FILES =
        new ParameterConfig<>(
            "max-files",
            Integer::valueOf,
            PositiveValidator.instance());

    Path root();

    Pattern regexFilter();

    int maxFiles();
}

