package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class FilesStaterConfigBuilder
    extends AbstractFilesStaterConfigBuilder<FilesStaterConfigBuilder>
{
    public FilesStaterConfigBuilder() {
        super(FilesStaterConfigDefaults.INSTANCE);
    }

    public FilesStaterConfigBuilder(final FilesStaterConfig config) {
        super(config);
    }

    public FilesStaterConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, FilesStaterConfigDefaults.INSTANCE);
    }

    public FilesStaterConfigBuilder(
        final IniConfig config,
        final FilesStaterConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public FilesStaterConfigBuilder self() {
        return this;
    }

    public ImmutableFilesStaterConfig build() throws ConfigException {
        return new ImmutableFilesStaterConfig(this);
    }
}

