package ru.yandex.http.util.server;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;

import ru.yandex.concurrent.CloseableTimerTask;
import ru.yandex.function.SimpleGenericAutoCloseableHolder;
import ru.yandex.http.config.ImmutableDnsConfig;
import ru.yandex.http.config.ImmutableURICheckConfig;
import ru.yandex.http.util.client.ClientBuilder;
import ru.yandex.io.GenericCloseableAdapter;

public class HttpChecker extends CloseableTimerTask {
    private final String name;
    private final Logger logger;
    private final String uri;
    private final CloseableHttpClient client;
    private volatile boolean ok = false;

    public HttpChecker(
        final String name,
        final Logger logger,
        final ImmutableURICheckConfig config,
        final ImmutableDnsConfig dnsConfig)
        throws HttpException, IOException
    {
        try (SimpleGenericAutoCloseableHolder<IOException> holder =
                new SimpleGenericAutoCloseableHolder<>(closeChain))
        {
            this.name = name;
            this.logger = logger;
            uri = config.uri().toASCIIString();
            client = ClientBuilder.createClient(config, dnsConfig);
            closeChain.add(new GenericCloseableAdapter<>(client));
            ok = check();
            holder.release();
        }
    }

    public String name() {
        return name;
    }

    public boolean ok() {
        return ok;
    }

    private boolean check() throws HttpException, IOException {
        try (CloseableHttpResponse response = client.execute(
                new HttpGet(uri)))
        {
            int status = response.getStatusLine().getStatusCode();
            logger.finest("HTTP check status: " + status);
            return status == HttpStatus.SC_OK;
        }
    }

    @Override
    public void run() {
        try {
            ok = check();
        } catch (Throwable t) {
            ok = false;
            logger.log(Level.WARNING, "Failed to check " + uri, t);
        }
    }
}

