package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HttpProxyConfigBuilder
    extends AbstractHttpProxyConfigBuilder<HttpProxyConfigBuilder>
{
    public HttpProxyConfigBuilder() {
        super(HttpProxyConfigDefaults.INSTANCE);
    }

    public HttpProxyConfigBuilder(final HttpProxyConfig config) {
        super(config);
    }

    public HttpProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, HttpProxyConfigDefaults.INSTANCE);
    }

    public HttpProxyConfigBuilder(
        final IniConfig config,
        final HttpProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HttpProxyConfigBuilder self() {
        return this;
    }

    public ImmutableHttpProxyConfig build() throws ConfigException {
        return new ImmutableHttpProxyConfig(this);
    }
}

