package ru.yandex.http.util.server;

import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.Header;

import ru.yandex.collection.LongPair;
import ru.yandex.http.config.ExternalDataConfig;
import ru.yandex.http.config.ExternalDataConfigBuilder;
import ru.yandex.http.config.HttpConnectionConfig;
import ru.yandex.http.config.ImmutableExternalDataConfig;
import ru.yandex.http.config.ImmutableURICheckConfig;
import ru.yandex.http.config.ServerHttpsConfig;
import ru.yandex.http.config.URICheckConfig;
import ru.yandex.http.config.URICheckConfigBuilder;
import ru.yandex.parser.config.SectionConfig;

public interface HttpServerConfig extends HttpConnectionConfig {
    static SectionConfig<
        FilesStaterConfig,
        ImmutableFilesStaterConfig,
        FilesStaterConfigBuilder>
    filesStaterParser(final String name) {
        return new SectionConfig<>(
            name,
            FilesStaterConfigBuilder::new,
            ImmutableFilesStaterConfig::new);
    }

    static SectionConfig<
        URICheckConfig,
        ImmutableURICheckConfig,
        URICheckConfigBuilder>
    httpCheckParser(final String name) {
        return new SectionConfig<>(
            name,
            URICheckConfigBuilder::new,
            ImmutableURICheckConfig::new);
    }

    static SectionConfig<
        ExternalDataConfig,
        ImmutableExternalDataConfig,
        ExternalDataConfigBuilder>
    externalDataConfigParser(final String name) {
        return new SectionConfig<>(
            name,
            ExternalDataConfigBuilder::new,
            ImmutableExternalDataConfig::new);
    }

    String name();

    String origin();

    int port();

    int workers();

    int connections();

    int maxGarbageConnections();

    int minConnectionsPerHost();

    int maxConnectionsPerHost();

    boolean rejectConnectionsOverLimit();

    int timeout();

    long connectionCloseCheckInterval();

    int timerResolution();

    int backlog();

    int linger();

    boolean gzip();

    boolean lazyBind();

    boolean pingEnabledOnStartup();

    Set<String> hiddenHeaders();

    List<Header> staticHeaders();

    List<LongPair<String>> staticStats();

    Map<String, Set<String>> statsAliases();

    String statsPrefix();

    boolean keepUnprefixedStats();

    boolean cpuStater();

    boolean memoryStater();

    boolean gcStater();

    boolean heapStater();

    boolean instanceAliveStater();

    Map<String, FileStore> freeSpaceSignals();

    Map<String, ? extends FilesStaterConfig> filesStaters();

    ServerHttpsConfig httpsConfig();

    Set<String> debugFlags();

    Set<Integer> keepAliveStatuses();
    /**
     * Set of http methods for which handler via register(handler) will
     * be registered
     * @return set of http methods ["POST", "GET"] etc
     */
    Set<String> defaultHttpMethods();

    Map<String, ? extends URICheckConfig> httpChecks();

    // Path to directory containing all previously fetched external data
    Path localCacheDir();

    Map<String, ? extends ExternalDataConfig> externalData();
}

