package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class HttpServerConfigBuilder
    extends AbstractHttpServerConfigBuilder<HttpServerConfigBuilder>
{
    public HttpServerConfigBuilder() {
        this(HttpServerConfigDefaults.INSTANCE);
    }

    public HttpServerConfigBuilder(final HttpServerConfig config) {
        super(config);
    }

    public HttpServerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, HttpServerConfigDefaults.INSTANCE);
    }

    public HttpServerConfigBuilder(
        final IniConfig config,
        final HttpServerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public HttpServerConfigBuilder self() {
        return this;
    }

    public ImmutableHttpServerConfig build() throws ConfigException {
        return new ImmutableHttpServerConfig(this);
    }
}

