package ru.yandex.http.util.server;

import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.Header;

import ru.yandex.collection.LongPair;
import ru.yandex.http.config.ExternalDataConfig;
import ru.yandex.http.config.HttpConnectionConfigDefaults;
import ru.yandex.http.config.ServerHttpsConfig;
import ru.yandex.http.config.URICheckConfig;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.request.RequestHandlerMapper;

public class HttpServerConfigDefaults
    extends HttpConnectionConfigDefaults
    implements HttpServerConfig
{
    public static final HttpServerConfigDefaults INSTANCE =
        new HttpServerConfigDefaults();

    private static final int DEFAULT_TIMEOUT = 1000;
    private static final long DEFAULT_CONNECTION_CLOSE_CHECK_INTERVAL = 1000L;
    private static final int DEFAULT_TIMER_RESOLUTION = 100;
    private static final int DEFAULT_BACKLOG = 1000;
    private static final int DEFAULT_LINGER = 3;
    private static final int DEFAULT_MAX_GARBAGE_CONNECTIONS = 1000;
    private static final Set<String> DEFAULT_METHODS =
        Collections.unmodifiableSet(
            new LinkedHashSet<>(
                Arrays.asList(RequestHandlerMapper.DEFAULT_METHODS)));

    protected HttpServerConfigDefaults() {
    }

    @Override
    public String name() {
        return "HttpServer";
    }

    @Override
    public String origin() {
        return name() + ' ' + HttpServerConfigBuilder.BUILT_DATE;
    }

    @Override
    public int port() {
        return -1;
    }

    @Override
    public int workers() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int connections() {
        return -1;
    }

    @Override
    public int maxGarbageConnections() {
        return DEFAULT_MAX_GARBAGE_CONNECTIONS;
    }

    @Override
    public int minConnectionsPerHost() {
        return 0;
    }

    @Override
    public int maxConnectionsPerHost() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean rejectConnectionsOverLimit() {
        return false;
    }

    @Override
    public int timeout() {
        return DEFAULT_TIMEOUT;
    }

    @Override
    public long connectionCloseCheckInterval() {
        return DEFAULT_CONNECTION_CLOSE_CHECK_INTERVAL;
    }

    @Override
    public int timerResolution() {
        return DEFAULT_TIMER_RESOLUTION;
    }

    @Override
    public int backlog() {
        return DEFAULT_BACKLOG;
    }

    @Override
    public int linger() {
        return DEFAULT_LINGER;
    }

    @Override
    public boolean gzip() {
        return false;
    }

    @Override
    public boolean lazyBind() {
        return false;
    }

    @Override
    public boolean pingEnabledOnStartup() {
        return true;
    }

    @Override
    public boolean cpuStater() {
        return true;
    }

    @Override
    public boolean memoryStater() {
        return false;
    }

    @Override
    public boolean gcStater() {
        return true;
    }

    @Override
    public boolean heapStater() {
        return true;
    }

    @Override
    public boolean instanceAliveStater() {
        return true;
    }

    @Override
    public Set<String> hiddenHeaders() {
        return YandexHeaders.DEFAULT_HIDDEN_HEADERS;
    }

    @Override
    public List<Header> staticHeaders() {
        return Collections.emptyList();
    }

    @Override
    public List<LongPair<String>> staticStats() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Set<String>> statsAliases() {
        return Collections.emptyMap();
    }

    @Override
    public String statsPrefix() {
        return null;
    }

    @Override
    public boolean keepUnprefixedStats() {
        return true;
    }

    @Override
    public Map<String, FileStore> freeSpaceSignals() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, ? extends FilesStaterConfig> filesStaters() {
        return Collections.emptyMap();
    }

    @Override
    public ServerHttpsConfig httpsConfig() {
        return null;
    }

    @Override
    public Set<String> debugFlags() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> keepAliveStatuses() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> defaultHttpMethods() {
        return DEFAULT_METHODS;
    }

    @Override
    public Map<String, URICheckConfig> httpChecks() {
        return Collections.emptyMap();
    }

    @Override
    public Path localCacheDir() {
        return null;
    }

    @Override
    public Map<String, ExternalDataConfig> externalData() {
        return Collections.emptyMap();
    }
}

