package ru.yandex.http.util.server;

import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableAuthConfig implements AuthConfig {
    private final String headerName;
    private final Set<Integer> allowedSrcs;
    private final boolean strict;
    private final boolean bypassLoopback;
    private final String userTicketHeaderName;
    private final UserTicketPresence userTicketPresence;

    public ImmutableAuthConfig(final AuthConfig config)
        throws ConfigException
    {
        headerName = HEADER_NAME.validate(config.headerName());
        allowedSrcs = ALLOWED_SRCS.validate(config.allowedSrcs());
        strict = STRICT.validate(config.strict());
        bypassLoopback = STRICT.validate(config.bypassLoopback());
        userTicketHeaderName =
            USER_TICKET_HEADER_NAME.validate(config.userTicketHeaderName());
        userTicketPresence =
            USER_TICKET_PRESENCE.validate(config.userTicketPresence());
    }

    public boolean disabled() {
        return !strict && allowedSrcs.isEmpty();
    }

    @Override
    public String headerName() {
        return headerName;
    }

    @Override
    public Set<Integer> allowedSrcs() {
        return allowedSrcs;
    }

    @Override
    public boolean strict() {
        return strict;
    }

    @Override
    public boolean bypassLoopback() {
        return bypassLoopback;
    }

    @Override
    public String userTicketHeaderName() {
        return userTicketHeaderName;
    }

    @Override
    public UserTicketPresence userTicketPresence() {
        return userTicketPresence;
    }
}

