package ru.yandex.http.util.server;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableAuthsConfig implements AuthsConfig {
    private final PatternMap<RequestInfo, ImmutableAuthConfig> auths;

    public ImmutableAuthsConfig(final AuthsConfig config)
        throws ConfigException
    {
        auths = config.auths().transform(ImmutableAuthConfig::new);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableAuthConfig> auths() {
        return auths;
    }
}

