package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.stater.ImmutableStaterConfig;

public class ImmutableAutoRegisterRequestStaterConfig
     implements AutoRegisterRequestStaterConfig
{
    private final AutoRegisterStatus status;
    private final ImmutableStaterConfig staterConfig;

    public ImmutableAutoRegisterRequestStaterConfig(
        final AutoRegisterRequestStaterConfig config)
        throws ConfigException
    {
        this.status = config.status();
        this.staterConfig =
            new ImmutableStaterConfig(
                config.staterConfig());
    }

    @Override
    public AutoRegisterStatus status() {
        return status;
    }

    @Override
    public ImmutableStaterConfig staterConfig() {
        return staterConfig;
    }
}
