package ru.yandex.http.util.server;

import java.nio.file.Path;
import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableFilesStaterConfig
    implements FilesStaterConfig, ImmutableConfig
{
    private final Path root;
    private final Pattern regexFilter;
    private final int maxFiles;

    public ImmutableFilesStaterConfig(final FilesStaterConfig config)
        throws ConfigException
    {
        root = ROOT.validate(config.root());
        regexFilter = REGEX_FILTER.validate(config.regexFilter());
        maxFiles = MAX_FILES.validate(config.maxFiles());
    }

    @Override
    public Path root() {
        return root;
    }

    @Override
    public Pattern regexFilter() {
        return regexFilter;
    }

    @Override
    public int maxFiles() {
        return maxFiles;
    }
}

