package ru.yandex.http.util.server;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLimitersConfig implements LimitersConfig {
    private final PatternMap<RequestInfo, ImmutableLimiterConfig>
        limiterConfigs;
    private final PatternMap<RequestInfo, Limiter> preparedLimiters;

    public ImmutableLimitersConfig(final LimitersConfig config)
        throws ConfigException
    {
        limiterConfigs =
            config.limiters().transform(ImmutableLimiterConfig::new);
        preparedLimiters =
            limiterConfigs.transform(ImmutableLimiterConfig::build);
    }

    public ImmutableLimitersConfig(
        final ImmutableLimitersConfig oldConfig,
        final LimitersConfig newConfig)
        throws ConfigException
    {
        limiterConfigs =
            newConfig.limiters().transform(ImmutableLimiterConfig::new);
        preparedLimiters = merge(oldConfig.preparedLimiters(), limiterConfigs);
    }

    private static PatternMap<RequestInfo, Limiter> merge(
        final PatternMap<RequestInfo, Limiter> currentMap,
        final PatternMap<RequestInfo, ImmutableLimiterConfig> newMap)
        throws ConfigException
    {
        final Map<Pattern<RequestInfo>, Limiter> current = new LinkedHashMap<>();
        currentMap.traverse(current::putIfAbsent);

        final Map<Pattern<RequestInfo>, ImmutableLimiterConfig> newone = new LinkedHashMap<>();
        newMap.traverse(newone::putIfAbsent);

        PatternMap<RequestInfo, Limiter> result = new PatternMap<>();
        final LinkedHashSet<Pattern<RequestInfo>> set = new LinkedHashSet<>(current.keySet());
        set.retainAll(newone.keySet());
        for (Pattern<RequestInfo> key: set) {
            Limiter currentLimiter = current.get(key);
            ImmutableLimiterConfig newConfig = newone.remove(key);
            result.put(key, new Limiter(newConfig, currentLimiter));
        }

        // TODO
        // in general, such a behaviour is dangerous - we could provoke (oldLimi + newLim) rps on route
        // we could code smth more mild, but in general it is hard to avoid
        for (Map.Entry<Pattern<RequestInfo>, ImmutableLimiterConfig> entry: newone.entrySet()) {
            result.put(entry.getKey(), new Limiter(entry.getValue()));
        }

        return result;
    }

    @Override
    public PatternMap<RequestInfo, ImmutableLimiterConfig> limiters() {
        return limiterConfigs;
    }

    public PatternMap<RequestInfo, Limiter> preparedLimiters() {
        return preparedLimiters;
    }
}

