package ru.yandex.http.util.server;

import java.io.Closeable;
import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.stater.StatsConsumer;

public class JsonStatsConsumer
    implements Closeable, StatsConsumer<IOException>
{
    private final JsonWriterBase writer;

    public JsonStatsConsumer(final JsonWriterBase writer) throws IOException {
        this.writer = writer;
        writer.startArray();
    }

    @Override
    public void close() throws IOException {
        writer.endArray();
    }

    @Override
    public void stat(final String name, final boolean value)
        throws IOException
    {
        writer.startArray();
        writer.value(name);
        if (value) {
            writer.value(1);
        } else {
            writer.value(0);
        }
        writer.endArray();
    }

    @Override
    public void stat(final String name, final long value) throws IOException {
        writer.startArray();
        writer.value(name);
        writer.value(value);
        writer.endArray();
    }

    @Override
    public void stat(final String name, final double value)
        throws IOException
    {
        writer.startArray();
        writer.value(name);
        writer.value(value);
        writer.endArray();
    }

    @Override
    public void stat(final String name, final long[] value)
        throws IOException
    {
        writer.startArray();
        writer.value(name);
        writer.startArray();
        for (int i = 0; i < value.length;) {
            writer.startArray();
            writer.value(value[i++]);
            writer.value(value[i++]);
            writer.endArray();
        }
        writer.endArray();
        writer.endArray();
    }
}

