package ru.yandex.http.util.server;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.LongMemorySizeParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.NotLessValidator;

public interface LimiterConfig {
    ParameterConfig<Integer> CONCURRENCY =
        new ParameterConfig<>(
            "concurrency",
            Integer::valueOf,
            new NotLessValidator<>(-1));
    ParameterConfig<Integer> PER_KEY_CONCURRENCY =
        new ParameterConfig<>(
            "per-key-concurrency",
            Integer::valueOf,
            new NotLessValidator<>(-1));
    ParameterConfig<Integer> PER_KEY_MINIMAL_CONCURRENCY =
        new ParameterConfig<>(
            "per-key-minimal-concurrency",
            Integer::valueOf,
            new NotLessValidator<>(-1));
    ParameterConfig<RequestFunction<LimiterFunctionContext>> KEY =
        new ParameterConfig<>(
            "key",
            new LimiterFunctionFactory(),
            GenericFunction.identity(),
            true);
    ParameterConfig<Long> MEMORY_LIMIT =
        new ParameterConfig<>(
            "memory-limit",
            LongMemorySizeParser.INSTANCE,
            new NotLessValidator<>(-1L));
    ParameterConfig<Integer> ERROR_STATUS_CODE =
        new ParameterConfig<>(
            "error-status-code",
            Integer::valueOf,
            NonNegativeValidator.instance());
    ParameterConfig<String> STATER_PREFIX =
        new ParameterConfig<>(
            "stater-prefix",
            GenericFunction.identity(),
            new NullToDefaultFunction<>(NonEmptyValidator.INSTANCE),
            true);
    ParameterConfig<Boolean> BYPASS_LOOPBACK = new ParameterConfig<>(
        "bypass-loopback",
        BooleanParser.INSTANCE,
        x -> x);

    int concurrency();

    int perKeyConcurrency();

    int perKeyMinimalConcurrency();

    RequestFunction<LimiterFunctionContext> key();

    long memoryLimit();

    int errorStatusCode();

    String staterPrefix();

    boolean bypassLoopback();
}

