package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class LimiterConfigBuilder
    extends AbstractLimiterConfigBuilder<LimiterConfigBuilder>
{
    public LimiterConfigBuilder() {
        super(LimiterConfigDefaults.INSTANCE);
    }

    public LimiterConfigBuilder(final LimiterConfig config) {
        super(config);
    }

    public LimiterConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, LimiterConfigDefaults.INSTANCE);
    }

    public LimiterConfigBuilder(
        final IniConfig config,
        final LimiterConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public LimiterConfigBuilder self() {
        return this;
    }

    public ImmutableLimiterConfig build() throws ConfigException {
        return new ImmutableLimiterConfig(this);
    }
}

