package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class LimitersConfigBuilder
    extends AbstractLimitersConfigBuilder<LimitersConfigBuilder>
{
    public LimitersConfigBuilder() {
        super(LimitersConfigDefaults.INSTANCE);
    }

    public LimitersConfigBuilder(final LimitersConfig config) {
        super(config);
    }

    public LimitersConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, LimitersConfigDefaults.INSTANCE);
    }

    public LimitersConfigBuilder(
        final IniConfig config,
        final LimitersConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public LimitersConfigBuilder self() {
        return this;
    }

    public ImmutableLimitersConfig build() throws ConfigException {
        return new ImmutableLimitersConfig(this);
    }
}

