package ru.yandex.http.util.server;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Logger;

import org.apache.http.HttpInetConnection;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.stater.RequestInfo;

public interface LoggingServerConnection
    extends GenericAutoCloseable<IOException>, HttpInetConnection
{
    String STATUS = "status";
    String REQUEST_LENGTH = "request_length";
    String RESPONSE_LENGTH = "response_length";
    String REQUEST_TIME = "request_time";
    String PROCESSING_TIME = "processing_time";
    String SESSION_START_TS = "session_start_ts";
    String PROCESS_START_TS = "process_start_ts";

    void setRequestContext(
        Logger logger,
        Consumer<RequestInfo> stater,
        GenericAutoCloseable<RuntimeException> resourcesReleaser,
        HttpContext context);

    void setStater(Consumer<RequestInfo> stater);

    void setSessionInfo(String name, Object value);

    default void setUpstreamStats(final Object value) {
        setSessionInfo(
            ProxyAccessLoggerConfigDefaults.UPSTREAM_STATS,
            value);
    }

    default void setHitsCount(final String value) {
        setSessionInfo(
            SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
            value);
    }

    long requestStartTime();
}

