package ru.yandex.http.util.server;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.HeaderUtils;
import ru.yandex.http.util.YandexHeaders;

public enum ResponseHostname implements HttpResponseInterceptor {
    INSTANCE;

    private static final Header HOSTNAME =
        HeaderUtils.createHeader(
            YandexHeaders.HOSTNAME,
            SessionContext.HOSTNAME);

    @Override
    public void process(
        final HttpResponse response,
        final HttpContext context)
    {
        response.setHeader(HOSTNAME);
    }
}

