package ru.yandex.http.util.server;

import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.HeaderUtils;
import ru.yandex.http.util.YandexHeaders;

public enum SessionId implements HttpResponseInterceptor {
    INSTANCE;

    @Override
    public void process(
        final HttpResponse response,
        final HttpContext context)
    {
        String sessionId =
            (String) context.getAttribute(HttpServer.SESSION_ID);
        if (sessionId != null) {
            response.addHeader(
                HeaderUtils.createHeader(YandexHeaders.SESSION_ID, sessionId));
        }
        String warningMessage =
            (String) context.getAttribute(HttpServer.WARNING_MESSAGE);
        if (warningMessage != null) {
            response.addHeader(
                HeaderUtils.createHeader(
                    YandexHeaders.X_YANDEX_WARNING,
                    warningMessage));
        }
    }
}

