package ru.yandex.http.util.server;

import java.util.EnumMap;
import java.util.Map;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.string.StringUtils;

public class UpstreamStater
    extends TimeFrameQueue<UpstreamStat>
    implements Stater
{
    private static final String ERRORS = "-errors_ammm";

    private final String prefix;
    private final String errorsStat;
    private final String requestsStat;
    private final String totalTimeStat;

    public UpstreamStater(
        final long metricsTimeFrame,
        final String prefix)
    {
        super(metricsTimeFrame);
        this.prefix = prefix + '-';
        errorsStat = prefix + ERRORS;
        requestsStat = prefix + "-requests_ammm";
        totalTimeStat = prefix + "-total-time_ammm";
    }

    @Override
    public <E extends Exception> void stats(
        final StatsConsumer<? extends E> statsConsumer)
        throws E
    {
        Map<RequestErrorType, int[]> errorTypes =
            new EnumMap<>(RequestErrorType.class);
        for (RequestErrorType errorType: RequestErrorType.values()) {
            errorTypes.put(errorType, new int[1]);
        }
        int requests = 0;
        long timeTotal = 0L;
        for (UpstreamStat stat: this) {
            ++requests;
            timeTotal += stat.timeTaken();
            RequestErrorType errorType = stat.errorType();
            if (errorType != null) {
                ++errorTypes.get(errorType)[0];
            }
        }
        int errors = 0;
        for (Map.Entry<RequestErrorType, int[]> entry: errorTypes.entrySet()) {
            int count = entry.getValue()[0];
            errors += count;
            statsConsumer.stat(
                StringUtils.concat(prefix, entry.getKey().toString(), ERRORS),
                count);
        }
        statsConsumer.stat(errorsStat, errors);
        statsConsumer.stat(requestsStat, requests);
        statsConsumer.stat(totalTimeStat, timeTotal);
    }
}

