package ru.yandex.http.util.server;

import java.util.function.Consumer;
import java.util.function.Function;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.FilterFutureCallback;
import ru.yandex.http.util.RequestErrorType;
import ru.yandex.util.timesource.TimeSource;

public class UpstreamStaterFutureCallback<T> extends FilterFutureCallback<T> {
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private final Consumer<? super UpstreamStat> stater;
    private final Function<Exception, RequestErrorType> errorClassifier;

    public UpstreamStaterFutureCallback(
        final FutureCallback<? super T> callback,
        final Consumer<? super UpstreamStat> stater)
    {
        this(callback, stater, RequestErrorType.ERROR_CLASSIFIER);
    }

    public UpstreamStaterFutureCallback(
        final FutureCallback<? super T> callback,
        final Consumer<? super UpstreamStat> stater,
        final Function<Exception, RequestErrorType> errorClassifier)
    {
        super(callback);
        this.stater = stater;
        this.errorClassifier = errorClassifier;
    }

    private void add(final RequestErrorType errorType) {
        stater.accept(
            new UpstreamStat(
                TimeSource.INSTANCE.currentTimeMillis() - start,
                errorType));
    }

    @Override
    public void completed(final T response) {
        add(null);
        super.completed(response);
    }

    @Override
    public void failed(final Exception e) {
        add(errorClassifier.apply(e));
        super.failed(e);
    }
}

