package ru.yandex.ljinx;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public abstract class AbstractCacheStoragesConfigBuilder
    <T extends AbstractCacheStoragesConfigBuilder<T>>
    implements CacheStoragesConfig
{
    public static final String SECTION = "cache-storage";

    private Map<String, CacheStorageConfig> cacheStorages;

    protected AbstractCacheStoragesConfigBuilder() {
        this(CacheStoragesConfigDefaults.INSTANCE);
    }

    protected AbstractCacheStoragesConfigBuilder(
        final CacheStoragesConfig config)
    {
        cacheStorages = new HashMap<>(config.cacheStorages());
    }

    protected AbstractCacheStoragesConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, CacheStoragesConfigDefaults.INSTANCE);
    }

    protected AbstractCacheStoragesConfigBuilder(
        final IniConfig config,
        final CacheStoragesConfig defaults)
        throws ConfigException
    {
        cacheStorages = loadCacheStorages(
            config,
            defaults);
    }

    public static Map<String, CacheStorageConfig> loadCacheStorages(
        final IniConfig section,
        final CacheStoragesConfig defaults)
        throws ConfigException
    {
        Map<String, CacheStorageConfig> cacheStorages =
            new HashMap<>();
        EnumParser<CacheStorageType> parser =
            new EnumParser<CacheStorageType>(CacheStorageType.class);
        for (Map.Entry<String, IniConfig> entry
                : section.sections().entrySet())
        {
            String subsection = entry.getKey();
            CacheStorageConfig subsectionDefaults =
                defaults.cacheStorages().get(subsection);
            if (subsectionDefaults != null
                && subsectionDefaults.type() == CacheStorageType.NULL)
            {
                subsectionDefaults = null;
            }
            IniConfig subsectionConfig = entry.getValue();
            CacheStorageType subsectionType =
                subsectionConfig.get(
                    "type",
                    CacheStorageType.NULL,
                    parser);
            if (subsectionDefaults != null
                    && subsectionDefaults.type() != subsectionType)
            {
                throw new ConfigException("subsection storage type mismatch: "
                    + "subsection type is " + subsectionType
                    + ", while parent is " + subsectionDefaults.type());
            }
            cacheStorages.put(
                subsection,
                subsectionType.create(subsectionConfig, subsectionDefaults));
        }
        return cacheStorages;
    }

    @Override
    public Map<String, CacheStorageConfig> cacheStorages() {
        return cacheStorages;
    }

    public T cacheStorages(
        final Map<String, ? extends CacheStorageConfig> cacheStorages)
    {
        this.cacheStorages = new HashMap<>(cacheStorages);
        return self();
    }

    public T cacheStorage(
        final String name,
        final CacheStorageConfig cacheStorage)
    {
        cacheStorages.put(
            name,
            cacheStorage);
        return self();
    }

    public ImmutableCacheStoragesConfig build() throws ConfigException {
        return new ImmutableCacheStoragesConfig(this);
    }

    protected abstract T self();
}
