package ru.yandex.ljinx;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractLjinxConfigBuilder
    <T extends AbstractLjinxConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements LjinxConfig
{
    private CacheStoragesConfigBuilder cacheStoragesConfig;
    private ProxyPassesConfigBuilder proxyPassesConfig;

    protected AbstractLjinxConfigBuilder(final LjinxConfig config) {
        super(config);
        cacheStoragesConfig(config.cacheStoragesConfig());
        proxyPassesConfig(config.proxyPassesConfig());
    }

    protected AbstractLjinxConfigBuilder(
        final IniConfig config,
        final LjinxConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        cacheStoragesConfig = new CacheStoragesConfigBuilder(
            config.section(CacheStoragesConfigBuilder.SECTION),
            new CacheStoragesConfigBuilder(
                config,
                defaults.cacheStoragesConfig()));
        proxyPassesConfig = new ProxyPassesConfigBuilder(
            config.section(ProxyPassesConfigBuilder.SECTION),
            new ProxyPassesConfigBuilder(
                config,
                defaults.proxyPassesConfig()));
    }

    @Override
    public CacheStoragesConfigBuilder cacheStoragesConfig() {
        return cacheStoragesConfig;
    }

    public T cacheStoragesConfig(
        final CacheStoragesConfig cacheStoragesConfig)
    {
        this.cacheStoragesConfig =
            new CacheStoragesConfigBuilder(cacheStoragesConfig);
        return self();
    }

    @Override
    public ProxyPassesConfigBuilder proxyPassesConfig() {
        return proxyPassesConfig;
    }

    public T proxyPassesConfig(final ProxyPassesConfig proxyPassesConfig) {
        this.proxyPassesConfig =
            new ProxyPassesConfigBuilder(proxyPassesConfig);
        return self();
    }
}
