package ru.yandex.ljinx;

import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractProxyPassesConfigBuilder
    <T extends AbstractProxyPassesConfigBuilder<T>>
    implements ProxyPassesConfig
{
    public static final String SECTION = "proxy-pass";

    private static final GenericFunction<
        ProxyPassConfig,
        ProxyPassConfigBuilder,
        RuntimeException> TRANSFORMER = new GenericFunction<
            ProxyPassConfig,
            ProxyPassConfigBuilder,
            RuntimeException>()
            {
                @Override
                public ProxyPassConfigBuilder apply(
                    final ProxyPassConfig config)
                {
                    if (config == null) {
                        return null;
                    } else {
                        return new ProxyPassConfigBuilder(config);
                    }
                }
            };

    private PatternMap<RequestInfo, ProxyPassConfigBuilder> proxyPasses;

    protected AbstractProxyPassesConfigBuilder() {
        this(ProxyPassesConfigDefaults.INSTANCE);
    }

    protected AbstractProxyPassesConfigBuilder(final ProxyPassesConfig config) {
        proxyPasses = config.proxyPasses().transform(TRANSFORMER);
    }

    protected AbstractProxyPassesConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, ProxyPassesConfigDefaults.INSTANCE);
    }

    protected AbstractProxyPassesConfigBuilder(
        final IniConfig config,
        final ProxyPassesConfig defaults)
        throws ConfigException
    {
        proxyPasses = loadProxyPasses(config, defaults);
    }

    public static PatternMap<RequestInfo, ProxyPassConfigBuilder>
        loadProxyPasses(
            final IniConfig section,
            final ProxyPassesConfig defaults)
            throws ConfigException
    {
        PatternMap<RequestInfo, ProxyPassConfigBuilder> proxyPasses =
            new PatternMap<>(
                new ProxyPassConfigBuilder(
                    section,
                    defaults.proxyPasses().asterisk()));

        for (Map.Entry<String, IniConfig> entry
                : section.sections().entrySet())
        {
            String subsection = entry.getKey();
            if (subsection.indexOf('/') != -1
                || subsection.indexOf(':') != -1
                || subsection.indexOf('*') != -1)
            {
                Pattern<RequestInfo> pattern =
                    RequestPatternParser.INSTANCE.apply(subsection);
                proxyPasses.put(
                    pattern,
                    new ProxyPassConfigBuilder(
                        entry.getValue(),
                        defaults.proxyPasses().get(pattern)));
            }
        }
        return proxyPasses;
    }

    @Override
    public PatternMap<RequestInfo, ProxyPassConfigBuilder> proxyPasses() {
        return proxyPasses;
    }

    public T proxyPasses(
        final PatternMap<RequestInfo, ? extends ProxyPassConfig> proxyPass)
    {
        this.proxyPasses = proxyPasses.transform(TRANSFORMER);
        return self();
    }

    public T proxyPass(
        final Pattern<RequestInfo> pattern,
        final ProxyPassConfigBuilder proxyPass)
    {
        proxyPasses.put(pattern, proxyPass);
        return self();
    }

    public T asterisk(final ProxyPassConfigBuilder proxyPass) {
        proxyPasses.put(new Pattern<>("", true), proxyPass);
        return self();
    }

    public ImmutableProxyPassesConfig build() throws ConfigException {
        return new ImmutableProxyPassesConfig(this);
    }

    protected abstract T self();
}
