package ru.yandex.ljinx;

import java.util.List;

import ru.yandex.http.config.AbstractHttpTargetConfigBuilder;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSiblingsConfigBuilder
    <T extends AbstractSiblingsConfigBuilder<T>>
    extends AbstractHttpTargetConfigBuilder<T>
    implements SiblingsConfig
{
    private RequestFunction<LjinxFunctionContext> hosts;
    private List<String> passHeaders;
    private long errorsTimeFrame;
    private long errorsTimeFrameGranularity;

    protected AbstractSiblingsConfigBuilder(final SiblingsConfig config) {
        super(config);
        hosts(config.hosts());
        passHeaders(config.passHeaders());
        errorsTimeFrame(config.errorsTimeFrame());
        errorsTimeFrameGranularity(config.errorsTimeFrameGranularity());
    }

    protected AbstractSiblingsConfigBuilder(
        final IniConfig config,
        final SiblingsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        hosts = HOSTS.extract(config, defaults.hosts());
        passHeaders = PASS_HEADERS.extract(config, defaults.passHeaders());
        errorsTimeFrame =
            ERRORS_TIME_FRAME.extract(config, defaults.errorsTimeFrame());
        errorsTimeFrameGranularity = ERRORS_TIME_FRAME_GRANULARITY.extract(
            config,
            defaults.errorsTimeFrameGranularity());
    }

    @Override
    public RequestFunction<LjinxFunctionContext> hosts() {
        return hosts;
    }

    public T hosts(final RequestFunction<LjinxFunctionContext> hosts) {
        this.hosts = hosts;
        return self();
    }

    @Override
    public List<String> passHeaders() {
        return passHeaders;
    }

    public T passHeaders(final List<String> passHeaders) {
        this.passHeaders = passHeaders;
        return self();
    }

    @Override
    public long errorsTimeFrame() {
        return errorsTimeFrame;
    }

    public T errorsTimeFrame(final long errorsTimeFrame) {
        this.errorsTimeFrame = errorsTimeFrame;
        return self();
    }

    @Override
    public long errorsTimeFrameGranularity() {
        return errorsTimeFrameGranularity;
    }

    public T errorsTimeFrameGranularity(
        final long errorsTimeFrameGranularity)
    {
        this.errorsTimeFrameGranularity = errorsTimeFrameGranularity;
        return self();
    }
}

