package ru.yandex.ljinx;

import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;

public class CacheResponse {
    private final BasicAsyncResponseProducerGenerator response;
    private final CacheType cacheType;
    private final long expireTimestamp;

    public CacheResponse(
        final BasicAsyncResponseProducerGenerator response,
        final CacheType cacheType,
        final long expireTimestamp)
    {
        this.response = response;
        this.cacheType = cacheType;
        this.expireTimestamp = expireTimestamp;
    }

    public BasicAsyncResponseProducerGenerator response() {
        return response;
    }

    public long expireTimestamp() {
        return expireTimestamp;
    }

    public CacheType cacheType() {
        return cacheType;
    }

    public enum CacheType {
        MEMORY("memory-hits"),
        DISK("disk-hits"),
        LOCK("lock-hits"),
        MDS("mds-hits"),
        MISS("cache-misses");

        private final String signalName;

        CacheType(final String signalName) {
            this.signalName = signalName;
        }

        public String signalName() {
            return signalName;
        }
    }
}
