package ru.yandex.ljinx;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;
import ru.yandex.stater.Stater;

public interface CacheStorage extends Closeable, Stater {
    void get(
        final ProxyPassSession session,
        final FutureCallback<CacheResponse> callback);

    void put(
        final ProxyPassSession session,
        final BasicAsyncResponseProducerGenerator value,
        final FutureCallback<Void> callback);

    void remove(
        final ProxyPassSession session,
        final FutureCallback<Void> callback);

    default void start() throws IOException { }

    Map<String, Object> status(boolean verbose);

    TimeFrameQueue<CacheResponse.CacheType> cacheStats();

    TimeFrameQueue<Long> siblingsRemovals();
}
