package ru.yandex.ljinx;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;

public final class CacheStorageConfigFactory {
    private CacheStorageConfigFactory() {
    }

    public CacheStorageConfig create(
        final IniConfig config,
        final CacheStorageConfig defaults)
        throws ConfigException
    {
        return new EnumParser<CacheStorageType>(CacheStorageType.class)
            .apply(config.getString("type"))
            .create(config, defaults);
    }
}
