package ru.yandex.ljinx;

public class CacheStorageException extends Exception {
    private static final long serialVersionUID = 0L;
    private static final String IN = " in ";
    private static final String STORAGE = " storage ";

    public CacheStorageException() {
    }

    public CacheStorageException(
        final CacheStorageType type,
        final String storageName,
        final String message)
    {
        super(message + IN + type.name() + STORAGE + storageName);
    }

    public CacheStorageException(final Throwable cause) {
        super(cause);
    }

    public CacheStorageException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
