package ru.yandex.ljinx;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum CacheStorageType {
    NULL {
        @Override
        public CacheStorageConfig create(
            final IniConfig config,
            final CacheStorageConfig defaults)
        {
            return NullCacheStorageConfig.INSTANCE;
        }
    },
    MEMORY {
        @Override
        public CacheStorageConfig create(
            final IniConfig config,
            final CacheStorageConfig defaults)
            throws ConfigException
        {
            MemoryCacheStorageConfig mDefaults = null;
            if (defaults instanceof MemoryCacheStorageConfig) {
                mDefaults = (MemoryCacheStorageConfig) defaults;
            }
            return new MemoryCacheStorageConfig(config, mDefaults);
        }
    },
    LUCENE {
        @Override
        public CacheStorageConfig create(
            final IniConfig config,
            final CacheStorageConfig defaults)
            throws ConfigException
        {
            LuceneCacheStorageConfig mDefaults = null;
            if (defaults instanceof LuceneCacheStorageConfig) {
                mDefaults = (LuceneCacheStorageConfig) defaults;
            }
            return new LuceneCacheStorageConfig(config, mDefaults);
        }
    },
    MDS {
        @Override
        public CacheStorageConfig create(
            final IniConfig config,
            final CacheStorageConfig defaults)
            throws ConfigException
        {
            MdsCacheStorageConfig mDefaults = null;
            if (defaults instanceof MdsCacheStorageConfig) {
                mDefaults = (MdsCacheStorageConfig) defaults;
            }
            return new MdsCacheStorageConfig(config, mDefaults);
        }
    };

    public abstract CacheStorageConfig create(
        final IniConfig config,
        final CacheStorageConfig defaults)
        throws ConfigException;
}
