package ru.yandex.ljinx;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.parser.config.ConfigException;

public class ImmutableCacheStoragesConfig implements CacheStoragesConfig {
    private final Map<String, ? extends CacheStorageConfig> cacheStorageConfigs;

    public ImmutableCacheStoragesConfig(final CacheStoragesConfig config)
        throws ConfigException
    {
        cacheStorageConfigs = config.cacheStorages();
    }

    @Override
    public Map<String, ? extends CacheStorageConfig> cacheStorages() {
        return cacheStorageConfigs;
    }

    public Map<String, CacheStorage> prepareStorages(final Ljinx ljinx)
        throws CacheStorageException
    {
        Map<String, CacheStorage> cacheStorages = new HashMap<>();
        for (Map.Entry<String, ? extends CacheStorageConfig> entry
            : cacheStorageConfigs.entrySet())
        {
            String name = entry.getKey();
            CacheStorageConfig config = entry.getValue();
            cacheStorages.put(name, config.createStorage(ljinx, name));
        }
        return cacheStorages;
    }
}
