package ru.yandex.ljinx;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLjinxConfig
    extends ImmutableHttpProxyConfig
    implements LjinxConfig
{
    private final ImmutableCacheStoragesConfig cacheStoragesConfig;
    private final ImmutableProxyPassesConfig proxyPassesConfig;

    public ImmutableLjinxConfig(final LjinxConfig config)
        throws ConfigException
    {
        super(config);
        cacheStoragesConfig =
            new ImmutableCacheStoragesConfig(config.cacheStoragesConfig());
        proxyPassesConfig =
            new ImmutableProxyPassesConfig(config.proxyPassesConfig());
    }

    @Override
    public ImmutableCacheStoragesConfig cacheStoragesConfig() {
        return cacheStoragesConfig;
    }

    @Override
    public ImmutableProxyPassesConfig proxyPassesConfig() {
        return proxyPassesConfig;
    }
}
