package ru.yandex.ljinx;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.collection.CollectionCompactor;
import ru.yandex.collection.IntSet;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;

public class ImmutableProxyPassConfig
    extends ImmutableHttpHostConfig
    implements ProxyPassConfig
{
    private final RequestFunction<LjinxFunctionContext> cacheKey;
    private final String cacheStorage;
    private final IntSet cacheCodes;
    private final IntSet goodCodes;
    private final Set<String> noCacheHeaders;
    private final Map<Integer, Long> cacheCodesTTL;
    private final List<String> passHeaders;
    private final ImmutableSiblingsConfig siblingsConfig;
    private final ImmutableSearchMapConfig searchMapConfig;
    private final Pattern pattern;
    private final String replacement;

    public ImmutableProxyPassConfig(final ProxyPassConfig config)
        throws ConfigException
    {
        super(config);
        cacheKey = config.cacheKey();
        cacheStorage = config.cacheStorage();
        cacheCodes = config.cacheCodes();
        goodCodes = config.goodCodes();
        noCacheHeaders = CollectionCompactor.compact(config.noCacheHeaders());
        cacheCodesTTL = CollectionCompactor.compact(config.cacheCodesTTL());
        passHeaders = CollectionCompactor.compact(config.passHeaders());
        SiblingsConfig siblingsConfig = config.siblingsConfig();
        if (siblingsConfig == null) {
            this.siblingsConfig = null;
        } else {
            this.siblingsConfig = new ImmutableSiblingsConfig(siblingsConfig);
        }
        SearchMapConfig searchMapConfig = config.searchMapConfig();
        if (searchMapConfig == null) {
            this.searchMapConfig = null;
        } else {
            this.searchMapConfig =
                new ImmutableSearchMapConfig(searchMapConfig);
        }
        pattern = config.pattern();
        replacement = config.replacement();
    }

    @Override
    public RequestFunction<LjinxFunctionContext> cacheKey() {
        return cacheKey;
    }

    @Override
    public String cacheStorage() {
        return cacheStorage;
    }

    @Override
    public IntSet cacheCodes() {
        return cacheCodes;
    }

    @Override
    public IntSet goodCodes() {
        return goodCodes;
    }

    @Override
    public Set<String> noCacheHeaders() {
        return noCacheHeaders;
    }

    @Override
    public Map<Integer, Long> cacheCodesTTL() {
        return cacheCodesTTL;
    }

    @Override
    public List<String> passHeaders() {
        return passHeaders;
    }

    @Override
    public ImmutableSiblingsConfig siblingsConfig() {
        return siblingsConfig;
    }

    @Override
    public ImmutableSearchMapConfig searchMapConfig() {
        return searchMapConfig;
    }

    @Override
    public Pattern pattern() {
        return pattern;
    }

    @Override
    public String replacement() {
        return replacement;
    }
}
