package ru.yandex.ljinx;

import ru.yandex.collection.PatternMap;
import ru.yandex.function.GenericFunction;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.parser.config.ConfigException;

public class ImmutableProxyPassesConfig implements ProxyPassesConfig {
    private static final GenericFunction<
        ProxyPassConfig,
        ImmutableProxyPassConfig,
        ConfigException> TRANSFORMER =
        new GenericFunction<
            ProxyPassConfig,
            ImmutableProxyPassConfig,
            ConfigException>()
        {
            @Override
            public ImmutableProxyPassConfig apply(
                final ProxyPassConfig config)
                throws ConfigException
            {
                if (config == null) {
                    return null;
                } else {
                    return new ImmutableProxyPassConfig(config);
                }
            }
        };

    private final PatternMap<RequestInfo, ImmutableProxyPassConfig> proxyPasses;

    public ImmutableProxyPassesConfig(final ProxyPassesConfig config)
        throws ConfigException
    {
        proxyPasses = config.proxyPasses().transform(TRANSFORMER);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableProxyPassConfig> proxyPasses() {
        return proxyPasses;
    }
}

