package ru.yandex.ljinx;

import java.util.List;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSiblingsConfig
    extends ImmutableHttpTargetConfig
    implements SiblingsConfig
{
    private final RequestFunction<LjinxFunctionContext> hosts;
    private final List<String> passHeaders;
    private final long errorsTimeFrame;
    private final long errorsTimeFrameGranularity;

    public ImmutableSiblingsConfig(final SiblingsConfig config)
        throws ConfigException
    {
        super(config);
        hosts = HOSTS.validate(config.hosts());
        passHeaders = PASS_HEADERS.validate(config.passHeaders());
        errorsTimeFrame = ERRORS_TIME_FRAME.validate(config.errorsTimeFrame());
        errorsTimeFrameGranularity = ERRORS_TIME_FRAME_GRANULARITY.validate(
            config.errorsTimeFrameGranularity());
    }

    @Override
    public RequestFunction<LjinxFunctionContext> hosts() {
        return hosts;
    }

    @Override
    public List<String> passHeaders() {
        return passHeaders;
    }

    @Override
    public long errorsTimeFrame() {
        return errorsTimeFrame;
    }

    @Override
    public long errorsTimeFrameGranularity() {
        return errorsTimeFrameGranularity;
    }
}

