package ru.yandex.ljinx;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class LjinxConfigBuilder
    extends AbstractLjinxConfigBuilder<LjinxConfigBuilder>
{
    public LjinxConfigBuilder() {
        super(LjinxConfigDefaults.INSTANCE);
    }

    public LjinxConfigBuilder(final LjinxConfig config) {
        super(config);
    }

    public LjinxConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, LjinxConfigDefaults.INSTANCE);
    }

    public LjinxConfigBuilder(
        final IniConfig config,
        final LjinxConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public LjinxConfigBuilder self() {
        return this;
    }

    public ImmutableLjinxConfig build() throws ConfigException {
        return new ImmutableLjinxConfig(this);
    }
}
