package ru.yandex.ljinx;

import java.util.concurrent.TimeUnit;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.LongMemorySizeParser;

public class MemoryCacheStorageConfig implements CacheStorageConfig {
    public static final long DEFAULT_TTL = TimeUnit.DAYS.toMillis(1L);
    public static final MemoryCacheStorageConfig DEFAULTS =
        new MemoryCacheStorageConfig();

    private final long capacity;
    private final long defaultTTL;

    protected MemoryCacheStorageConfig() {
        this.capacity = 0;
        this.defaultTTL = DEFAULT_TTL;
    }

    public MemoryCacheStorageConfig(
        final IniConfig config,
        final MemoryCacheStorageConfig other)
        throws ConfigException
    {
        MemoryCacheStorageConfig defaults = other;
        if (defaults == null) {
            defaults = DEFAULTS;
        }
        capacity = config.get(
            "capacity",
            defaults.capacity(),
            LongMemorySizeParser.INSTANCE);
        defaultTTL = config.get(
            "default-ttl",
            defaults.defaultTTL(),
            DurationParser.POSITIVE_LONG);
    }

    public long capacity() {
        return capacity;
    }

    public long defaultTTL() {
        return defaultTTL;
    }

    @Override
    public CacheStorageType type() {
        return CacheStorageType.MEMORY;
    }

    @Override
    public CacheStorage createStorage(final Ljinx ljinx, final String name)
        throws CacheStorageException
    {
        return new MemoryCacheStorage(name, ljinx.config(), this);
    }
}
