package ru.yandex.ljinx;

import java.util.Collections;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;

public class NullCacheStorage extends AbstractCacheStorage {
    public NullCacheStorage(
        final String storageName,
        final ImmutableBaseServerConfig serverConfig)
    {
        super(storageName, serverConfig);
    }

    @Override
    public void close() {
    }

    @Override
    public void get(
        final ProxyPassSession session,
        final FutureCallback<CacheResponse> callback)
    {
        callback.completed(null);
    }

    @Override
    public void put(
        final ProxyPassSession session,
        final BasicAsyncResponseProducerGenerator value,
        final FutureCallback<Void> callback)
    {
        callback.completed(null);
    }

    @Override
    public void remove(
        final ProxyPassSession session,
        final FutureCallback<Void> callback)
    {
        callback.completed(null);
    }

    @Override
    public Map<String, Object> status(final boolean verbose) {
        return Collections.emptyMap();
    }
}
