package ru.yandex.ljinx;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.collection.IntSet;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.parser.searchmap.SearchMapConfig;

public interface ProxyPassConfig extends HttpHostConfig {
    RequestFunction<LjinxFunctionContext> cacheKey();

    String cacheStorage();

    IntSet cacheCodes();

    // Non-cacheable but still ok codes, that should not be counted as failure
    IntSet goodCodes();

    Set<String> noCacheHeaders();

    Map<Integer, Long> cacheCodesTTL();

    List<String> passHeaders();

    SiblingsConfig siblingsConfig();

    SearchMapConfig searchMapConfig();

    Pattern pattern();

    String replacement();
}
