package ru.yandex.ljinx;

import java.net.URI;

import org.apache.http.HttpHost;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ProxyPassConfigBuilder
    extends AbstractProxyPassConfigBuilder<ProxyPassConfigBuilder>
{
    public ProxyPassConfigBuilder() {
        super(ProxyPassConfigDefaults.INSTANCE);
    }

    public ProxyPassConfigBuilder(final ProxyPassConfig config) {
        super(config);
    }

    public ProxyPassConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(addHostToConfig(config), ProxyPassConfigDefaults.INSTANCE);
    }

    public ProxyPassConfigBuilder(
        final IniConfig config,
        final ProxyPassConfig defaults)
        throws ConfigException
    {
        super(addHostToConfig(config), defaults);
    }

    @Override
    public ProxyPassConfigBuilder self() {
        return this;
    }

    public ImmutableProxyPassConfig build() throws ConfigException {
        return new ImmutableProxyPassConfig(this);
    }

    // temporarily for configs with "uri" but without a "host"
    private static IniConfig addHostToConfig(final IniConfig config)
        throws ConfigException
    {
        if (!config.keys().contains("host")) {
            URI uri = config.getURI("uri", null);
            if (uri != null) {
                HttpHost host =
                    new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                config.put("host", host.toString());
            }
        }
        return config;
    }
}
