package ru.yandex.ljinx;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.collection.EmptyIntSet;
import ru.yandex.collection.IntSet;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.ljinx.function.RequestDataFunction;
import ru.yandex.parser.searchmap.SearchMapConfig;

public class ProxyPassConfigDefaults
    extends HttpHostConfigDefaults
    implements ProxyPassConfig
{
    public static final ProxyPassConfigDefaults INSTANCE =
        new ProxyPassConfigDefaults();

    protected ProxyPassConfigDefaults() {
    }

    @Override
    public RequestFunction<LjinxFunctionContext> cacheKey() {
        return new RequestDataFunction<LjinxFunctionContext>();
    }

    @Override
    public String cacheStorage() {
        return "default";
    }

    @Override
    public IntSet cacheCodes() {
        return EmptyIntSet.INSTANCE;
    }

    @Override
    public IntSet goodCodes() {
        return EmptyIntSet.INSTANCE;
    }

    @Override
    public Set<String> noCacheHeaders() {
        return Collections.emptySet();
    }

    @Override
    public Map<Integer, Long> cacheCodesTTL() {
        return Collections.emptyMap();
    }

    @Override
    public List<String> passHeaders() {
        return Collections.emptyList();
    }

    @Override
    public SiblingsConfig siblingsConfig() {
        return null;
    }

    @Override
    public SearchMapConfig searchMapConfig() {
        return null;
    }

    @Override
    public Pattern pattern() {
        return null;
    }

    @Override
    public String replacement() {
        return null;
    }
}
