package ru.yandex.ljinx;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

import com.twmacinta.util.MD5;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.request.function.RequestFunctionValue;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.uri.CgiParamsBase;
import ru.yandex.util.string.HexStrings;

public class ProxyPassSession implements LjinxFunctionContext {
    private final ProxyPassHandler handler;
    private final ProxySession session;
    private final String uri;
    private BasicAsyncRequestProducerGenerator producerGenerator;
    private final HttpHost targetHost;
    private final String cacheUrl;
    private RequestFunctionValue cacheKey;

    private Long ttl = null;

    // CSOFF: ParameterNumber
    public ProxyPassSession(
        final ProxyPassHandler handler,
        final ProxySession session,
        final String uri,
        final BasicAsyncRequestProducerGenerator producerGenerator,
        final HttpHost targetHost,
        final boolean computeCacheKey)
        throws BadRequestException
    {
        this.handler = handler;
        this.session = session;
        this.uri = uri;
        this.producerGenerator = producerGenerator;
        this.targetHost = targetHost;

        if (computeCacheKey) {
            try {
                cacheKey = handler.config().cacheKey().value(this);
            } catch (ExecutionException e) {
                throw new BadRequestException(
                    "Cache key cannot be computed",
                    e);
            }
            int sep = uri.indexOf('?');
            String location;
            if (sep == -1) {
                location = uri;
            } else {
                location = uri.substring(0, sep);
            }
            cacheUrl =
                handler.config().cacheStorage() + '_'
                + location + '_'
                + reduceKey(cacheKey);
            logger().info("Cache key <" + cacheKey + '>');
        } else {
            cacheKey = null;
            cacheUrl = null;
        }
    }
    // CSON: ParameterNumber

    @Override
    public HttpRequest request() {
        return session.request();
    }

    @Override
    public CgiParamsBase params() {
        return session.params();
    }

    private static String reduceKey(final RequestFunctionValue key) {
        MD5 md5 = new MD5();
        key.appendTo(md5);
        return new String(HexStrings.UPPER.process(md5.Final()));
    }

    public String uri() {
        return uri;
    }

    public Logger logger() {
        return session.logger();
    }

    public ProxySession session() {
        return session;
    }

    @Override
    public BasicAsyncRequestProducerGenerator producerGenerator() {
        return producerGenerator;
    }

    public BasicAsyncRequestProducerGenerator releaseProducerGenerator() {
        BasicAsyncRequestProducerGenerator producerGenerator =
            this.producerGenerator;
        this.producerGenerator = null;
        return producerGenerator;
    }

    public String cacheUrl() {
        return cacheUrl;
    }

    public RequestFunctionValue cacheKey() {
        return cacheKey;
    }

    public void cacheKey(final RequestFunctionValue cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String cacheStorage() {
        return handler.config().cacheStorage();
    }

    public CacheStorage storage() {
        return handler.cacheStorage();
    }

    @Override
    public SearchMap searchMap() {
        return handler.searchMap();
    }

    @Override
    public void shuffleHosts(
        final List<HttpHost> hosts,
        final long seed,
        final boolean randomShuffle)
    {
        handler.shuffleHosts(hosts, seed, randomShuffle);
    }

    public HttpHost targetHost() {
        return targetHost;
    }

    public Long ttl() {
        return ttl;
    }

    public void ttl(final Long ttl) {
        this.ttl = ttl;
    }
}
