package ru.yandex.ljinx;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;
import ru.yandex.ljinx.function.LjinxFunctionFactory;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface SiblingsConfig extends HttpTargetConfig {
    ParameterConfig<RequestFunction<LjinxFunctionContext>> HOSTS =
        new ParameterConfig<>(
            "hosts",
            LjinxFunctionFactory.INSTANCE,
            GenericFunction.identity());

    ParameterConfig<List<String>> PASS_HEADERS = new ParameterConfig<>(
        "pass-headers",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new),
        GenericFunction.identity());

    ParameterConfig<Long> ERRORS_TIME_FRAME = new ParameterConfig<>(
        "errors-time-frame",
        DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
        NonNegativeValidator.instance());

    ParameterConfig<Long> ERRORS_TIME_FRAME_GRANULARITY =
        new ParameterConfig<>(
            "errors-time-frame-granularity",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());

    RequestFunction<LjinxFunctionContext> hosts();

    List<String> passHeaders();

    long errorsTimeFrame();

    long errorsTimeFrameGranularity();
}

