package ru.yandex.ljinx;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SiblingsConfigBuilder
    extends AbstractSiblingsConfigBuilder<SiblingsConfigBuilder>
{
    public SiblingsConfigBuilder() {
        super(SiblingsConfigDefaults.INSTANCE);
    }

    public SiblingsConfigBuilder(final SiblingsConfig config) {
        super(config);
    }

    public SiblingsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, SiblingsConfigDefaults.INSTANCE);
    }

    public SiblingsConfigBuilder(
        final IniConfig config,
        final SiblingsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SiblingsConfigBuilder self() {
        return this;
    }

    public ImmutableSiblingsConfig build() throws ConfigException {
        return new ImmutableSiblingsConfig(this);
    }
}

