package ru.yandex.ljinx;

import java.util.Collections;
import java.util.List;

import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.ljinx.function.LjinxFunctionContext;

public class SiblingsConfigDefaults
    extends HttpTargetConfigDefaults
    implements SiblingsConfig
{
    public static final SiblingsConfigDefaults INSTANCE =
        new SiblingsConfigDefaults();

    private static final long DEFAULT_ERRORS_TIME_FRAME = 60000L;
    private static final long DEFAULT_ERRORS_TIME_FRAME_GRANULARITY = 10000L;

    protected SiblingsConfigDefaults() {
    }

    @Override
    public RequestFunction<LjinxFunctionContext> hosts() {
        return null;
    }

    @Override
    public List<String> passHeaders() {
        return Collections.emptyList();
    }

    @Override
    public long errorsTimeFrame() {
        return DEFAULT_ERRORS_TIME_FRAME;
    }

    @Override
    public long errorsTimeFrameGranularity() {
        return DEFAULT_ERRORS_TIME_FRAME_GRANULARITY;
    }
}

