package ru.yandex.ljinx.function;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.request.function.HostListValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;

public class ConcatHostsFunction<V extends LjinxFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V>[] args;

    public ConcatHostsFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        this.args = args.clone();
        if (args.length < 2) {
            throw new ParseException(
                "Function \"concat-hosts\" accepts at least 2 arguments",
                0);
        }
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        List<HttpHost> hosts = new ArrayList<>();
        for (RequestFunction<V> arg: args) {
            hosts.addAll(arg.value(context).hostListValue());
        }
        return new HostListValue(hosts);
    }

    @Override
    public String toString() {
        return "concat-hosts" + Arrays.toString(args);
    }
}

