package ru.yandex.ljinx.function;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.request.function.HostListValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;

public class IncrementPortFunction<V extends LjinxFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V> hosts;
    private final RequestFunction<V> increment;

    public IncrementPortFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length != 2) {
            throw new ParseException(
                "Function \"increment-port\" accepts exactly 2 arguments",
                0);
        }
        hosts = args[0];
        increment = args[1];
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        int increment = (int) this.increment.value(context).longValue();
        List<HttpHost> hosts = this.hosts.value(context).hostListValue();
        List<HttpHost> result = new ArrayList<>(hosts.size());
        for (HttpHost host: hosts) {
            result.add(
                new HttpHost(
                    host.getHostName(),
                    host.getPort() + increment,
                    host.getSchemeName()));
        }
        return new HostListValue(result);
    }

    @Override
    public String toString() {
        return "increment-port(" + hosts + ',' + increment + ')';
    }
}

