package ru.yandex.ljinx.function;

import java.text.ParseException;

import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionFactory;
import ru.yandex.parser.string.EnumParser;

public class LjinxFunctionFactory
    extends RequestFunctionFactory<LjinxFunctionContext>
{
    public static final LjinxFunctionFactory INSTANCE =
        new LjinxFunctionFactory();

    protected LjinxFunctionFactory() {
    }

    @Override
    protected RequestFunction<LjinxFunctionContext> createFunction(
        final String name,
        final RequestFunction<LjinxFunctionContext>[] args)
        throws ParseException
    {
        try {
            return new EnumParser<LjinxFunctionType>(LjinxFunctionType.class)
                .apply(name)
                .create(args);
        } catch (RuntimeException e) {
            return super.createFunction(name, args);
        }
    }
}
