package ru.yandex.ljinx.function;

import java.text.ParseException;

import ru.yandex.http.util.request.function.RequestFunction;

public enum LjinxFunctionType {
    REQUEST {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
        {
            return new RequestDataFunction<V>(args);
        }
    },
    REQUEST_MD5 {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
        {
            return new RequestMd5Function<V>(args);
        }
    },
    INCREMENT_PORT {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new IncrementPortFunction<V>(args);
        }
    },
    SET_PORT {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new SetPortFunction<V>(args);
        }
    },
    SHUFFLE_HOSTS {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new ShuffleHostsFunction<V>(args);
        }
    },
    RANDOM_SHUFFLE_HOSTS {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new RandomShuffleHostsFunction<V>(args);
        }
    },
    SEARCHMAP_HOSTS {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new SearchMapHostsFunction<V>(args);
        }
    },
    CONCAT_HOSTS {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new ConcatHostsFunction<V>(args);
        }
    },
    TRUNCATE_HOSTS {
        @Override
        public <V extends LjinxFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new TruncateHostsFunction<V>(args);
        }
    };

    public abstract <V extends LjinxFunctionContext> RequestFunction<V> create(
        final RequestFunction<V>[] args)
        throws ParseException;
}
