package ru.yandex.ljinx.function;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.request.function.HostListValue;
import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.http.util.request.function.RequestFunctionValue;

public class RandomShuffleHostsFunction<V extends LjinxFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V>[] args;

    public RandomShuffleHostsFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        this.args = args.clone();
        if (args.length < 2) {
            throw new ParseException(
                "Function \"random-shuffle-hosts\" accepts at least"
                + " 2 arguments",
                0);
        }
    }

    @Override
    public RequestFunctionValue value(final V session)
        throws ExecutionException
    {
        List<HttpHost> hosts = new ArrayList<>();
        for (int i = 0; i < args.length - 1; ++i) {
            hosts.addAll(args[i].value(session).hostListValue());
        }
        session.shuffleHosts(
            hosts,
            args[args.length - 1].value(session).longValue(),
            true);
        return new HostListValue(hosts);
    }

    @Override
    public String toString() {
        return "random-shuffle-hosts" + Arrays.toString(args);
    }
}

